﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports Microsoft.VisualBasic.FileIO

Public Class CopyDirectoryPanel
    Inherits FileSystemSample.TaskPanelBase

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.AutoSize = False
        Me.DescriptionTextBox.Multiline = True
        Me.DescriptionTextBox.Size = New System.Drawing.Size(568, 50)
        Me.DescriptionTextBox.Text = "Copies a directory (including its head) under a target a directory.  If a directo" & _
            "ry of the same name exists under the target directory, the contents of the copie" & _
            "d directory will be merged into the existing directory.  Like other methods on M" & _
            "y.Computer.FileSystem.MoveFile optionally shows Windows shell dialogs"
        '
        'CopyDirectoryPanel
        '
        Me.Name = "CopyDirectoryPanel"

    End Sub

#End Region

    Private Shared panelInstance As CopyDirectoryPanel
    Friend WithEvents sourceChooser As New DirectoryChooser
    Friend WithEvents targetChooser As New DirectoryChooser()
    Friend WithEvents newNameTextBox As New TextBox()
    Friend WithEvents overWriteComboBox As New ComboBox()
    Friend WithEvents showUIComboBox As New ComboBox()
    Friend WithEvents onUserCancelComboBox As New ComboBox()


    ''' <summary>
    ''' 获取此控件的实例
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As CopyDirectoryPanel
        If (panelInstance Is Nothing) Then
            panelInstance = New CopyDirectoryPanel()
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板，并为 My.Computer.FileSystem.CopyDirectory 中的每个参数添加一个控件
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub CopyDirectoryPanel_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("sourceDirectoryName", sourceChooser)
        MyBase.AddParameter("destinationDirectoryName", targetChooser)
        MyBase.AddParameter("showUI", showUIComboBox)
        MyBase.AddParameter("onUserCancel", onUserCancelComboBox)
    End Sub


    ''' <summary>
    ''' 初始化所有用户控件
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.CopyDirectory("

        sourceChooser.Reset()
        targetChooser.Reset()
        Me.newNameTextBox.Text = String.Empty

        overWriteComboBox.Items.AddRange(New String() {"True", "False"})
        overWriteComboBox.AutoSize = True
        overWriteComboBox.SelectedItem = "False"

        showUIComboBox.Items.AddRange(New String() {"OnlyErrorDialogs", "AllDialogs"})
        showUIComboBox.AutoSize = True
        showUIComboBox.SelectedItem = "AllDialogs"

        onUserCancelComboBox.Items.AddRange(New String() {"Do Nothing", "Throw Exception"})
        onUserCancelComboBox.AutoSize = True
        onUserCancelComboBox.SelectedItem = "Throw Exception"
    End Sub


    ''' <summary>
    ''' 根据所提供的输入复制目录。为清楚起见，使用命名参数。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        Try
            My.Computer.FileSystem.CopyDirectory( _
                                    sourceDirectoryName:=Me.sourceChooser.Directory, _
                                    destinationDirectoryName:=Me.targetChooser.Directory, _
                                    showUI:=CType(UIOption.Parse(GetType(UIOption), CType(Me.showUIComboBox.SelectedItem, String)), UIOption), _
                                    onUserCancel:=ParseUICancelOption(Me.onUserCancelComboBox))
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

    End Sub

    ''' <summary>
    ''' 将所有控件初始化为它们的默认值
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub

    ''' <summary>
    ''' 当用户选择一个目录后，会自动使用该选定目录填充“newName”字段。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub sourceChooser_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles sourceChooser.Leave
        Me.newNameTextBox.Text = My.Computer.FileSystem.GetDirectoryInfo(sourceChooser.Directory).Name
    End Sub
End Class

